

import java.util.Vector;

// Referenced classes of package duggelz.jape:
//            DataChangeListener, DataChangeEvent

public class DataChangeMixin
{

    public DataChangeMixin()
    {
        listeners = new Vector(1);
    }

    public synchronized void addDataChangeListener(DataChangeListener l)
    {
        if(l == null)
        {
            return;
        } else
        {
            listeners.addElement(l);
            return;
        }
    }

    public void fireDataChangeEvent(DataChangeEvent event)
    {
        int size = listeners.size();
        for(int idx = 0; idx < size; idx++)
            ((DataChangeListener)listeners.elementAt(idx)).dataChanged(event);

    }

    public synchronized void removeDataChangeListener(DataChangeListener l)
    {
        if(l == null)
        {
            return;
        } else
        {
            listeners.removeElement(l);
            return;
        }
    }

    private Vector listeners;
}